# vBulletin User Blocker

A Chrome extension that blocks users on vBulletin forums. Hides their posts and any quotes of their content.

## Features

- **Block users via right-click**: Right-click on a username or select the username text and right-click to block
- **Hides posts**: Posts from blocked users are replaced with a minimal placeholder
- **Hides quotes**: Quoted content from blocked users is also hidden
- **"Show anyway" option**: Reveal individual hidden posts temporarily
- **Manage block list**: Use the extension popup to view, add, or remove blocked users
- **Synced across devices**: Block list syncs via Chrome's storage

## Installation

1. Open Chrome and go to `chrome://extensions/`
2. Enable **Developer mode** (toggle in top-right)
3. Click **Load unpacked**
4. Select this `vbulletin-blocker` folder

## Usage

### Blocking a user

**Method 1 - Right-click:**
1. Right-click on a username link in any forum post
2. Select "Block this user" from the context menu
3. Confirm the block

**Method 2 - Select text:**
1. Select/highlight the username text
2. Right-click on the selection
3. Select "Block this user"

**Method 3 - Popup:**
1. Click the extension icon in Chrome toolbar
2. Type the username in the input field
3. Click "Block"

### Unblocking a user

1. Click the extension icon
2. Find the user in the list
3. Click "Unblock"

### Viewing hidden content

Each hidden post/quote has a "Show anyway" button if you want to temporarily reveal it.

## Compatibility

Works with:
- vBulletin 4.x
- vBulletin 5.x
- Many vBulletin-based forum variants
- Partial XenForo compatibility

The extension uses multiple CSS selectors to detect posts and quotes, so it should work with most vBulletin themes and configurations.

## Troubleshooting

**Username not detected on right-click?**
- Try selecting the username text first, then right-click
- Make sure you're clicking directly on the username link

**Posts not being hidden?**
- Refresh the page after blocking a user
- Some heavily customized themes may need additional selectors

**Extension not working at all?**
- Check that it's enabled in `chrome://extensions/`
- Check the console for errors (F12 → Console tab)

## Privacy

- Block list is stored locally in Chrome sync storage
- No data is sent to any external servers
- The extension only runs on pages you visit
